/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.starrocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.starrocks.client.StarRocksResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceStarRocks
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceStarRocks.class);
    public static final String ACCESS_TYPE_SELECT = "select";

    public List<RangerPolicy> getDefaultRangerPolicies() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceStarRocks.getDefaultRangerPolicies()");
        }
        List ret = super.getDefaultRangerPolicies();
        for (RangerPolicy defaultPolicy : ret) {
            if (!defaultPolicy.getName().contains("all") || !StringUtils.isNotBlank((String)this.lookUpUser)) continue;
            ArrayList<RangerPolicy.RangerPolicyItemAccess> accessListForLookupUser = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_SELECT));
            RangerPolicy.RangerPolicyItem policyItemForLookupUser = new RangerPolicy.RangerPolicyItem();
            policyItemForLookupUser.setUsers(Collections.singletonList(this.lookUpUser));
            policyItemForLookupUser.setAccesses(accessListForLookupUser);
            policyItemForLookupUser.setDelegateAdmin(Boolean.valueOf(false));
            defaultPolicy.getPolicyItems().add(policyItemForLookupUser);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceStarRocks.getDefaultRangerPolicies()");
        }
        return ret;
    }

    public Map<String, Object> validateConfig() throws Exception {
        Map<String, Object> ret = new HashMap<String, Object>();
        String serviceName = this.getServiceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("RangerServiceStarRocks.validateConfig(): Service: " + serviceName);
        }
        if (this.configs != null) {
            try {
                if (!this.configs.containsKey("password")) {
                    this.configs.put("password", null);
                }
                ret = StarRocksResourceManager.connectionTest(serviceName, this.configs);
            }
            catch (HadoopException he) {
                LOG.error("<== RangerServiceStarRocks.validateConfig() Error:" + (Object)((Object)he));
                throw he;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("RangerServiceStarRocks.validateConfig(): Response: " + ret);
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        List<String> ret = new ArrayList<String>();
        String serviceName = this.getServiceName();
        String serviceType = this.getServiceType();
        Map configs = this.getConfigs();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceStarRocks.lookupResource() Context: (" + context + ")");
        }
        if (context != null) {
            try {
                if (!configs.containsKey("password")) {
                    configs.put("password", null);
                }
                ret = StarRocksResourceManager.getStarRocksResources(serviceName, serviceType, configs, context);
            }
            catch (Exception e) {
                LOG.error("<==RangerServiceStarRocks.lookupResource() Error : " + e);
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceStarRocks.lookupResource() Response: (" + ret + ")");
        }
        return ret;
    }
}

