/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.starrocks.client;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.starrocks.client.StarRocksClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarRocksConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(StarRocksConnectionManager.class);
    protected ConcurrentMap<String, StarRocksClient> starrocksConnectionCache = new ConcurrentHashMap<String, StarRocksClient>();
    protected ConcurrentMap<String, Boolean> repoConnectStatusMap = new ConcurrentHashMap<String, Boolean>();

    public StarRocksClient getStarRocksConnection(final String serviceName, String serviceType, final Map<String, String> configs) {
        StarRocksClient starrocksClient = null;
        if (serviceType != null) {
            starrocksClient = (StarRocksClient)this.starrocksConnectionCache.get(serviceName);
            if (starrocksClient == null) {
                if (configs != null) {
                    Callable<StarRocksClient> connectStarRocks = new Callable<StarRocksClient>(){

                        @Override
                        public StarRocksClient call() throws Exception {
                            return new StarRocksClient(serviceName, configs);
                        }
                    };
                    LOG.error("start");
                    try {
                        starrocksClient = (StarRocksClient)TimedEventUtil.timedTask((Callable)connectStarRocks, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        LOG.error("Error connecting to StarRocks repository: " + serviceName + " using config: " + configs, (Throwable)e);
                    }
                    LOG.error("end");
                    if (starrocksClient == null) {
                        LOG.error("null");
                    } else {
                        LOG.error("not null");
                    }
                    StarRocksClient oldClient = null;
                    oldClient = starrocksClient != null ? this.starrocksConnectionCache.putIfAbsent(serviceName, starrocksClient) : (StarRocksClient)this.starrocksConnectionCache.get(serviceName);
                    if (oldClient != null) {
                        if (starrocksClient != null) {
                            starrocksClient.close();
                        }
                        starrocksClient = oldClient;
                    }
                    this.repoConnectStatusMap.put(serviceName, true);
                } else {
                    LOG.error("Connection Config not defined for asset :" + serviceName, new Throwable());
                }
            } else {
                try {
                    starrocksClient.getCatalogList("*", null);
                }
                catch (Exception e) {
                    this.starrocksConnectionCache.remove(serviceName);
                    starrocksClient.close();
                    starrocksClient = this.getStarRocksConnection(serviceName, serviceType, configs);
                }
            }
        } else {
            LOG.error("Asset not found with name " + serviceName, new Throwable());
        }
        return starrocksClient;
    }
}

