/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.starrocks.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.starrocks.client.StarRocksClient;
import org.apache.ranger.services.starrocks.client.StarRocksConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarRocksResourceManager {
    private static final Logger LOG = LoggerFactory.getLogger(StarRocksResourceManager.class);

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) throws Exception {
        Map<String, Object> ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> StarRocksResourceManager.connectionTest() ServiceName: " + serviceName + " Configs: " + configs);
        }
        try {
            ret = StarRocksClient.connectionTest(serviceName, configs);
        }
        catch (Exception e) {
            LOG.error("<== StarRocksResourceManager.connectionTest() Error: " + e);
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== StarRocksResourceManager.connectionTest() Result : " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getStarRocksResources(String serviceName, String serviceType, Map<String, String> configs, ResourceLookupContext context) throws Exception {
        List resultList;
        block36: {
            String userInput = context.getUserInput();
            if (userInput == null || userInput.isEmpty()) {
                userInput = "*";
            }
            String resourceName = context.getResourceName().trim().toLowerCase();
            if (LOG.isDebugEnabled()) {
                LOG.debug("<== StarRocksResourceManager.getStarRocksResources() UserInput: \"" + userInput + "\" resourceName : " + resourceName + " resourceMap: " + context.getResources());
            }
            resultList = null;
            try {
                StarRocksClient starRocksClient = new StarRocksConnectionManager().getStarRocksConnection(serviceName, serviceType, configs);
                Callable<List> callableObj = null;
                if (starRocksClient == null) break block36;
                switch (resourceName) {
                    case "catalog": {
                        Map resourceMap = context.getResources();
                        List catalogList = (List)resourceMap.get("catalog");
                        String catalogName = userInput;
                        callableObj = () -> starRocksClient.getCatalogList(catalogName, catalogList);
                        break;
                    }
                    case "database": {
                        Map resourceMap = context.getResources();
                        List catalogList = (List)resourceMap.get("catalog");
                        List databaseList = (List)resourceMap.get("database");
                        String dbName = userInput;
                        callableObj = () -> starRocksClient.getDatabaseList(dbName, catalogList, databaseList);
                        break;
                    }
                    case "table": {
                        Map resourceMap = context.getResources();
                        List catalogList = (List)resourceMap.get("catalog");
                        List databaseList = (List)resourceMap.get("database");
                        List tableList = (List)resourceMap.get("table");
                        String tableName = userInput;
                        callableObj = () -> starRocksClient.getTableList(tableName, catalogList, databaseList, tableList);
                        break;
                    }
                    case "column": {
                        Map resourceMap = context.getResources();
                        List catalogList = (List)resourceMap.get("catalog");
                        List databaseList = (List)resourceMap.get("database");
                        List tableList = (List)resourceMap.get("table");
                        List columnList = (List)resourceMap.get("column");
                        String columnName = userInput;
                        callableObj = () -> starRocksClient.getColumnList(columnName, catalogList, databaseList, tableList, columnList);
                        break;
                    }
                    case "view": {
                        Map resourceMap = context.getResources();
                        List catalogList = (List)resourceMap.get("catalog");
                        List databaseList = (List)resourceMap.get("database");
                        List viewList = (List)resourceMap.get("view");
                        String viewName = userInput;
                        callableObj = () -> starRocksClient.getViewList(viewName, catalogList, databaseList, viewList);
                        break;
                    }
                    case "materialized_view": {
                        Map resourceMap = context.getResources();
                        List catalogList = (List)resourceMap.get("catalog");
                        List databaseList = (List)resourceMap.get("database");
                        List mvList = (List)resourceMap.get("materialized_view");
                        String mvName = userInput;
                        callableObj = () -> starRocksClient.getMaterializedViewList(mvName, catalogList, databaseList, mvList);
                        break;
                    }
                    case "function": {
                        Map resourceMap = context.getResources();
                        List catalogList = (List)resourceMap.get("catalog");
                        List databaseList = (List)resourceMap.get("database");
                        List mvList = (List)resourceMap.get("function");
                        String functionName = userInput;
                        callableObj = () -> starRocksClient.getFunctionList(functionName, catalogList, databaseList, mvList);
                        break;
                    }
                    case "global_function": {
                        Map resourceMap = context.getResources();
                        List globalFunctionList = (List)resourceMap.get("global_function");
                        String functionName = userInput;
                        callableObj = () -> starRocksClient.getFunctionList(functionName, globalFunctionList);
                        break;
                    }
                    case "resource": {
                        Map resourceMap = context.getResources();
                        List globalFunctionList = (List)resourceMap.get("resource");
                        String functionName = userInput;
                        callableObj = () -> starRocksClient.getResourceList(functionName, globalFunctionList);
                        break;
                    }
                    case "resource_group": {
                        Map resourceMap = context.getResources();
                        List globalFunctionList = (List)resourceMap.get("resource_group");
                        String functionName = userInput;
                        callableObj = () -> starRocksClient.getResourceGroupList(functionName, globalFunctionList);
                        break;
                    }
                    case "storage_volume": {
                        Map resourceMap = context.getResources();
                        List globalFunctionList = (List)resourceMap.get("storage_volume");
                        String functionName = userInput;
                        callableObj = () -> starRocksClient.getStorageVolumeList(functionName, globalFunctionList);
                        break;
                    }
                    case "user": {
                        Map resourceMap = context.getResources();
                        List globalFunctionList = (List)resourceMap.get("user");
                        String functionName = userInput;
                        callableObj = () -> starRocksClient.getUserList(functionName, globalFunctionList);
                        break;
                    }
                }
                if (callableObj != null) {
                    Object object = starRocksClient;
                    synchronized (object) {
                        resultList = (List)TimedEventUtil.timedTask(callableObj, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                        break block36;
                    }
                }
                LOG.error("Could not initiate a StarRocks timedTask");
            }
            catch (Exception e) {
                LOG.error("Unable to get StarRocks resource", (Throwable)e);
                throw e;
            }
        }
        return resultList;
    }
}

